
int sqSize=16;
int[][] decayT = new int[sqSize][sqSize];
float[][] volume = new float[sqSize][sqSize];
int decayMax=100;
int notesDensity=decayMax*sqSize;
ArrayList rightS = new ArrayList();
ArrayList leftS = new ArrayList();
int frameRate=8;
int frameLength=44100/frameRate;
int sT=0;

PFont font;

import krister.Ess.*;
AudioChannel right;
AudioChannel left;

void setup() {
  frameRate(frameRate);
  smooth();
  size(300,300);
  font = loadFont("ArialMT-10.vlw");
  textFont(font);
  for (int y=0;y<sqSize;y++) {
    for (int x=0;x<sqSize;x++) {
      decayT[x][y]=0;
      volume[x][y]=0;
    }
  }
  noStroke();
  Ess.start(this);
}

void draw() {
  playNotes();
  generateSound();
  visu();
  saveFrame("frame_#####.png");
}

void generateSound() {
  for (int i=0;i<frameLength;i++) {
    float thisSampleR=0;
    float thisSampleL=0;    
    for (int y=0;y<sqSize;y++) {
      for (int x=0;x<sqSize;x++) {
        volume[x][y]=max(volume[x][y]+((float)decayT[x][y]-decayMax)/(frameLength*5),0);
        if (volume[x][y]==0) decayT[x][y]=0;        
        thisSampleR+=volume[x][y]*waveFrom(x,y)*(x);
        thisSampleL+=volume[x][y]*waveFrom(x,y)*(sqSize-x);
      }
    }
    rightS.add(new OneSample(thisSampleR));
    leftS.add(new OneSample(thisSampleL));
    sT++;
  }
}

float waveFrom(int x, int y) {
  float freq=(x+20)*(sqSize-y);
  return sin((float)sT*TWO_PI*freq/frameLength);
}

void playNotes() {
  notesDensity=max(floor(notesDensity*9/10),0);
  for (int y=0;y<sqSize;y++) {
    for (int x=0;x<sqSize;x++) {
      if (random(notesDensity)<1) {
        int thisDecay=floor(random(random(decayMax)));
        decayT[x][y]=thisDecay;
        volume[x][y]=decayMax-min(sqSize-y,decayMax-1);
        notesDensity+=thisDecay;
      }
    }
  }
}

void visu() {
  background(0xFF);
  fill(0);
  for (int y=0;y<sqSize;y++) {
    for (int x=0;x<sqSize;x++) {
      if (decayT[x][y]!=0) {
        text(char(1632+decayT[x][y]),(x+5)*(width/(sqSize+10)),(y+5)*(height/(sqSize+10)));
      }
    }
  }
}

void normalizeSample() {
  float maxVolume=0;
  for (int i=0;i<rightS.size();i++) {
    if (abs(((OneSample)rightS.get(i)).theSample())>maxVolume) {
      maxVolume=abs(((OneSample)rightS.get(i)).theSample());
    }
    if (abs(((OneSample)leftS.get(i)).theSample())>maxVolume) {
      maxVolume=abs(((OneSample)leftS.get(i)).theSample());
    }
  }
  for (int i=0;i<rightS.size();i++) {
    rightS.set(i,new OneSample(((OneSample)rightS.get(i)).theSample()/maxVolume));
    leftS.set(i,new OneSample(((OneSample)leftS.get(i)).theSample()/maxVolume));
  }
}

public void stop() {
  normalizeSample();
  AudioChannel right=new AudioChannel();
  AudioChannel left=new AudioChannel();  
  right.initChannel(rightS.size());
  left.initChannel(leftS.size());
  for (int i=0;i<rightS.size();i++) {
    right.samples[i]=((OneSample)rightS.get(i)).theSample();
    left.samples[i]=((OneSample)leftS.get(i)).theSample();
  }
  right.saveSound(dataPath("right.wav"));
  left.saveSound(dataPath("left.wav"));
  Ess.stop();
  super.stop();
}

class OneSample {
  float theSample;
  OneSample(float theSample) {
    this.theSample=theSample;
  }
  public float theSample() {
    return theSample;
  }
}


