
import ddf.minim.*;

Minim minim;
AudioSample jingle;
float freq=55;
float buffLimit=round(44100/freq);
int iStart=0;
int frR=55;

float[] leftChannel;
float[] rightChannel;

void setup() {
  frameRate(frR);
  size(64,48);
  background(0);  
  minim = new Minim(this);
  jingle = minim.loadSample("jingle.wav", 2048);
  leftChannel = jingle.getChannel(BufferedAudio.LEFT);
  rightChannel = jingle.getChannel(BufferedAudio.RIGHT);
}

void draw() {
  noStroke();
  fill(0,200);
  rect(0,0,width,height);
  stroke(0,255,0);
  for (int i=iStart;i<iStart+buffLimit-1;i++) {
    line((i-iStart)*width/buffLimit,rightChannel[i]*(height/2)+(height/2),(i+1-iStart)*width/buffLimit,rightChannel[i+1]*(height/2)+(height/2));
  }
  iStart=round((iStart+(44100/frR))%(rightChannel.length-buffLimit));
  saveFrame("/data/oscilo-####.png");
}





