
int nbSt = 500;
PImage[] ims = new PImage[nbSt];
int stSize=30;
int nbX=20;
int nbY=20;
int[][] rot = new int[nbX][nbY];
int[][] id = new int[nbX][nbY];
int clipboard=0;

int[] kernel = {-1, 0,
                 0,-1,
                 1, 0,
                 0, 1};

int[] kernelPourLeFiltre = {-1,-1,+0,-1,+1,-1,
                            -1,+0,+0,+0,+1,+0,
                            -1,+1,+0,+1,+1,+1};
                           
float[] kernelSharpen = {-1,-1,-1,
                         -1,+9,-1,
                         -1,-1,-1};

float divSharpFactor = 5.0/5.0;
                        
boolean isFilter = false;

int[][] crouteBuffer;

PGraphics PGTemp;

void setup() {
  size(nbX*stSize, nbY*stSize);
  PGTemp = createGraphics(width, height,P2D);
  crouteBuffer = new int[nbX * nbY][2];
  MitRomney(crouteBuffer);
  
  for (int i=0;i<nbSt;i++) {
    ims[i]=loadImage(dataPath(nf(i, 3)+".png"));
  }
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {      
      rot[x][y]= 0;
      id[x][y]= nbSt;
    }
  }
}

void InitialiseWithMitRomney()
{
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      int meOU = y * nbX + x;      
      rot[x][y]= crouteBuffer[meOU][0];
      id[x][y]= crouteBuffer[meOU][1];
    }
  }
}

void draw() {
  background(0);
  PGTemp.beginDraw();
  PGTemp.background(0);
  for (int x=0;x<nbX;x++) {
    for (int y=0;y<nbY;y++) {
      if (id[x][y]==nbSt) {
        // nothing
      } 
      else {
        PGTemp.pushMatrix();
        PGTemp.translate(x*stSize+stSize/2, y*stSize+stSize/2);
        PGTemp.rotate(rot[x][y]*HALF_PI);
        PGTemp.image(ims[id[x][y]], -stSize/2, -stSize/2);
        PGTemp.popMatrix();
      }
    }
  }
  if (editO) {
    id[cIDX][cIDY]=floor(baseId+((float)mouseY-baseMY)/10);
    int maxi = nbSt+1;
    while (id[cIDX][cIDY]<0 || id[cIDX][cIDY]>=maxi) id[cIDX][cIDY] = (id[cIDX][cIDY]+maxi) % maxi;
    clipboard = id[cIDX][cIDY];
  }
  PGTemp.endDraw();
  
  if(isFilter)
  {
    loadPixels();
    PGTemp.loadPixels();
    for(int x = 0; x < width; ++x)
    {
      for(int y = 0; y < height; ++y)
      {        
        float sumR = 0;
        float sumG = 0;
        float sumB = 0;
        for(int k = 0; k < kernelPourLeFiltre.length; k+=2)
        {
          int dx = constrain(x + kernelPourLeFiltre[k + 0], 0, width - 1);
          int dy = constrain(y + kernelPourLeFiltre[k + 1], 0, height - 1);
          color aroundColor = PGTemp.pixels[dy * width + dx];
          sumR += red(aroundColor) * kernelSharpen[k/2];
          sumG += green(aroundColor) * kernelSharpen[k/2];
          sumB += blue(aroundColor) * kernelSharpen[k/2];
        }
        pixels[y * width + x] = color(constrain(sumR*divSharpFactor,0,255),
                                      constrain(sumG*divSharpFactor,0,255),
                                      constrain(sumB*divSharpFactor,0,255));
      }     
    }  
    updatePixels();
    PGTemp.updatePixels(); 
  }
  else
  {
    image(PGTemp,0,0);
  }
}

int baseMX=0;
int baseMY=0;
int cIDX=0;
int cIDY=0;
int baseId=0;
boolean editO=false;

void mousePressed() {
  int x=floor(mouseX/stSize);
  int y=floor(mouseY/stSize);
  baseMX=mouseX;
  baseMY=mouseY;
  baseId=clipboard;
  cIDX=x;
  cIDY=y;
  if (mouseButton==LEFT) editO=true;
  if (mouseButton==RIGHT) rot[x][y]=(rot[x][y]+1)%(4);
}

void mouseReleased() {
  editO=false;
}

void keyPressed() {
  if (keyCode==ENTER) {
    save("result.png");
    String[] out = new String[nbSt];
    int[] nb = new int[nbSt];
    for (int i=0;i<nbSt;i++) {
      nb[i]=0;
    }
    for (int x=0;x<nbX;x++) {
      for (int y=0;y<nbY;y++) {
        if (id[x][y]<nbSt) nb[id[x][y]]++;
      }
    }
    for (int i=0;i<nbSt;i++) out[i] = str(nb[i]);
    saveStrings("out.txt", out);
  }
  if (keyCode==DELETE) {
    id[cIDX][cIDY]=nbSt;
  }
  if (keyCode==RIGHT) {
    int tmpId = id[(cIDX+1)%nbX][cIDY];
    id[(cIDX+1)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX+1+nbX)%nbX;
  }  
  if (keyCode==LEFT) {
    int tmpId = id[(cIDX-1+nbX)%nbX][cIDY];
    id[(cIDX-1+nbX)%nbX][cIDY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDX=(cIDX-1+nbX)%nbX;
  }  
  if (keyCode==DOWN) {
    int tmpId = id[cIDX][(cIDY+1)%nbY];
    id[cIDX][(cIDY+1)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY+1+nbY)%nbY;
  }  
  if (keyCode==UP) {
    int tmpId = id[cIDX][(cIDY-1+nbY)%nbY];
    id[cIDX][(cIDY-1+nbY)%nbY] = id[cIDX][cIDY];
    id[cIDX][cIDY] = tmpId;
    cIDY=(cIDY-1+nbY)%nbY;
  }
  if (key == 'A' || key == 'a')
  {
    MitRomney(crouteBuffer);
    InitialiseWithMitRomney(); 
  }
  if (key == 'F' || key == 'f')
  {
    isFilter = !isFilter;
  }
}


void MitRomney(int[][] buffer)
{
  for(int j = 0; j < buffer.length; ++j)
  {
    buffer[j][0] = 0;
    buffer[j][1] = 500;  
  }
    
  int RandomBGNumber = 16;
  int startIndex = (int)random(0,124);
  startIndex *= 4;  
  
  println("/-----------------------------------------------------------------------------------------/");
  println("start : " + startIndex);
  
  for(int rd = 0; rd < RandomBGNumber; ++rd)
  {    
    int cx = (int)random(0, nbX);
    int cy = (int)random(0, nbY);
    if(buffer[cy * nbX + cx][1] == 500)
    {
      buffer[cy * nbX + cx][1] = startIndex + (rd%2)*2;
    }
    else
    {
      rd--;  
    }
  }
  
  //copie du buffet
  int[][] tempBuffer = new int[buffer.length][2];
  CopyMitRomney(buffer,tempBuffer);
  int emptyCell = nbX * nbY;
  int it = 0;  
  
  while(emptyCell > 0)
  {
    it++;
    emptyCell = nbX * nbY;
        
    for(int x = 0; x < nbX; ++x)
    { 
      for(int y = 0; y < nbY; ++y)
      { 
        int meOU = y * nbX + x;  
        if(buffer[meOU][1] != 500)
        {
          emptyCell--;
          for(int a = 0; a < kernel.length; a += 2)
          {
            int extX = ((x + kernel[a + 0]) + nbX) % nbX;
            int extY = ((y + kernel[a + 1]) + nbY) % nbY;
            
            if(random(0.00, 1.00) > 0.8 && buffer[extY * nbX + extX][1] == 500)
            {
                tempBuffer[extY * nbX + extX][1] = buffer[meOU][1];
            } 
          }      
        }        
      }
    }
    //println("buffer : " + emptyCell + ", iteration : " + it);
    CopyMitRomney(tempBuffer, buffer);
  }
  //diagonal
  for(int x = 0; x < nbX; ++x)
  {
    for(int y = 0; y < nbY; ++y)
    {      
      int meOU = y * nbX + x;
      if(tempBuffer[meOU][1] == startIndex)
      {
        int[] shem = {0, 0, 0, 0};
        for(int a = 0; a < kernel.length / 2; a++)
        {
          int extX = x + kernel[a * 2 + 0];
          int extY = y + kernel[a * 2 + 1];
          
          if(extX >= 0 && extX < nbX && extY >= 0 && extY < nbY)
          {
            if(tempBuffer[extY * nbX + extX][1] == startIndex)
            {
              shem[a] = 0;    
            }
            else
            {
              shem[a] = 1; 
            }
          }        
        }
        //println("shem : " + shem[0] + ", " + shem[1] + ", " + shem[2] + ", " + shem[3]);
        if(shem[0] == 1 && shem[1] == 1 && shem[2] != 1 && shem[3] != 1)
        {
          buffer[meOU][1] = startIndex + 1;
          buffer[meOU][0] = 2;
          //println("A");
        }
        if(shem[0] != 1 && shem[1] == 1 && shem[2] == 1 && shem[3] != 1)
        {
          buffer[meOU][1] = startIndex + 1;
          buffer[meOU][0] = 3;
          //println("B");
        }
        if(shem[0] != 1 && shem[1] != 1 && shem[2] == 1 && shem[3] == 1)
        {
          buffer[meOU][1] = startIndex + 1;
          buffer[meOU][0] = 0;
          //println("C");
        }
        if(shem[0] == 1 && shem[1] != 1 && shem[2] != 1 && shem[3] == 1)
        {
          buffer[meOU][1] = startIndex + 1;
          buffer[meOU][0] = 1;
          //println("D");
        }
      }
    }  
  }
  
  int youssoundourRamequinMax = (int)constrain(random(-1,12),0,5);
  for(int i = 0; i < youssoundourRamequinMax; ++i)
  {
    float a = random(0.00,1.00);
    if(a < 0.3333)
    {
      Youssoundour(buffer);
    }
    else if(a > 0.6666)
    {
      Ramequin(buffer); 
    }    
  }
}

void Ramequin(int[][] buffer)
{
  int xpos = (int)random(0,nbX);
  int ypos = (int)random(0,nbY);
  int colorOffset = (int)(buffer[ypos * nbX + xpos][1] / 2);
  colorOffset = colorOffset * 2;
  if(random(0.00,1.00) > 0.5)
  {
    colorOffset = (int)random(0,249);
    colorOffset *= 2;
  }
  int[] idRamequins = {ypos * nbX + xpos,
                       ypos * nbX + ((xpos + 1) % nbX),
                       ((ypos+1) % nbY) * nbX + ((xpos + 1) % nbX),
                       ((ypos+1) % nbY) * nbX + xpos
                       };
  
  int[][] motifs = {{0,1,2,3},{1,0,3,2},{1,0,2,3}};
    
  buffer[idRamequins[0]][1] = colorOffset + 1;
  buffer[idRamequins[1]][1] = colorOffset + 1;
  buffer[idRamequins[2]][1] = colorOffset + 1;
  buffer[idRamequins[3]][1] = colorOffset + 1;
  
  int offsetRotation = (int)random(0,4);
  int motif = (int)random(0,3);
  buffer[idRamequins[0]][0] = motifs[motif][0] + offsetRotation;
  buffer[idRamequins[1]][0] = motifs[motif][1] + offsetRotation;
  buffer[idRamequins[2]][0] = motifs[motif][2] + offsetRotation;
  buffer[idRamequins[3]][0] = motifs[motif][3] + offsetRotation;
}

void Youssoundour(int[][] buffer)
{  
  int sSize = (int)random(1,4);
  int hSize = (int)random(4, nbY);
  int sNbX = nbY;
  int sNbY = nbX;
  int xpos = (int)random(0,nbX);
  int ypos = (int)random(0,nbY);
  int colorOffset = (int)random(0,125);
  
  boolean orientation = false;
    
  if(random(0.00, 1.00) >= 0.5)
  {
    sNbX = nbX;
    sNbY = nbY;
    hSize = (int)random(4, nbX);
    xpos = (int)random(0,nbY);
    ypos = (int)random(0,nbX);
    orientation = true;
  }
  int cf = 0;
  if(random(0.00, 1.00) >= 0.5)
  {
    cf = 2;
  }
  
  for(int x = 0; x < sSize; ++x)
  {
    for(int y = 0; y < hSize; ++y)
    {
      int ix = (x+xpos) % sNbX;
      int iy = (y+ypos) % sNbY;
      int meOU;
      if(!orientation)
      {
        meOU = iy * sNbX + ix;
      }
      else
      {
        meOU = ix * sNbY + iy;  
      }
      buffer[meOU][1] = (buffer[meOU][1] + colorOffset * 4 + cf) % 500;
    }  
  }
}

void CopyMitRomney(int[][] from, int[][] to)
{  
  for(int i = 0; i < to.length; ++i)
  {
    for(int j = 0; j < to[i].length; ++j)
    {
      to[i][j] = from[i][j];
    }
  }  
}

