import processing.core.*; 
import processing.xml.*; 

import java.awt.FileDialog; 
import sojamo.drop.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class applyalpha extends PApplet {





SDrop drop;
PFont font;

int phase=0;
PImage imA=createImage(100,100,RGB);
PImage imRGB=createImage(100,100,RGB);
PImage imARGB=createImage(100,100,ARGB);

//loaded ?
boolean loA=false;
boolean loRGB=false;
boolean loARGB=false;

public void setup() {
  size(300,300);
  frameRate(5);
  drop=new SDrop(this);
  font=loadFont(dataPath("Calibri-12.vlw"));
  textFont(font);   
  updateScreen();
  strokeWeight(2);
}

public void draw() {
  updateScreen();
}

public void updateScreen() {
  background(0);
  stroke(0xFF);
  fill(random(0xFF),random(0xFF),random(0xFF));
  rect(40,40,100,100);//imA
  rect(160,40,100,100);//imRGB
  rect(100,160,100,100);//imARGB
  pushMatrix();
  translate(40,40);
  scale(100f/imA.width,100f/imA.height);
  image(imA,0,0);
  popMatrix();
  pushMatrix();
  translate(160,40);
  scale(100f/imRGB.width,100f/imRGB.height);
  image(imRGB,0,0);
  popMatrix();
  pushMatrix();
  translate(100,160);
  scale(100f/imARGB.width,100f/imARGB.height);
  image(imARGB,0,0);
  popMatrix();
  fill(0xFF);
  text("A", 40, 37);
  text("RGB", 160, 37);
  text("ARGB", 100, 157);
}

public void dropEvent(DropEvent theDropEvent) {
  if (theDropEvent.x()>=40 && theDropEvent.x()<=140 && theDropEvent.y()>=40 && theDropEvent.y()<=140) {
    // put the file in the imA image
    loadImA(theDropEvent.file().toString());
    generateARGB();
    loA=true;
    loARGB=true;
  }
  if (theDropEvent.x()>=160 && theDropEvent.x()<=260 && theDropEvent.y()>=40 && theDropEvent.y()<=140) {
    loadImRGB(theDropEvent.file().toString());
    generateARGB();
    loRGB=true;
    loARGB=true;
  }
  if (theDropEvent.x()>=100 && theDropEvent.x()<=200 && theDropEvent.y()>=160 && theDropEvent.y()<=260) {
    // put the file in both A and RGB images
    loadImA(theDropEvent.file().toString());
    loadImRGB(theDropEvent.file().toString());
    generateARGB();
    loA=true;
    loRGB=true;    
    loARGB=true;    
  }
  updateScreen();  
}

public void loadImA(String url) {
  PImage imATemp=loadImage(url);
  imA=createImage(imATemp.width,imATemp.height,RGB);
  imA.loadPixels();
  imATemp.loadPixels();
  // checks if the file has transparency values
  boolean transparencyPresent=false;
  for (int i=0;i<imATemp.pixels.length;i++) {  
    if (alpha(imATemp.pixels[i])<0xFF) {
      transparencyPresent=true;
    }
  }
  // convert the image to a B/W layer
  if(transparencyPresent) {
    // convert alpha channel to B/W values
    for (int i=0;i<imATemp.pixels.length;i++) {
      imA.pixels[i]=color(PApplet.parseInt(alpha(imATemp.pixels[i])));
    }
  }
  else{
    // if no alpha variations, then load brightness values as transparency
    for (int i=0;i<imATemp.pixels.length;i++) {
      imA.pixels[i]=color(PApplet.parseInt(brightness(imATemp.pixels[i])));
    }
  }
  imA.updatePixels();
  imATemp.updatePixels();
}

public void loadImRGB(String url) {
  // put the file in the imRGB image
  imRGB=loadImage(url);
  imRGB.loadPixels();
  // remove the alpha channel
  for (int i=0;i<imRGB.pixels.length;i++) {
    imRGB.pixels[i]=color(red(imRGB.pixels[i]),green(imRGB.pixels[i]),blue(imRGB.pixels[i]));
  }
  imRGB.updatePixels();
}

public void generateARGB() {
  imARGB=createImage(imRGB.width,imRGB.height,ARGB);
  imARGB.loadPixels();
  for (int x=0;x<imARGB.width;x++) {
    for (int y=0;y<imARGB.height;y++) {
      int alphaValue=PApplet.parseInt(brightness(imA.get(floor((float)x*imA.width/imRGB.width),floor((float)y*imA.height/imRGB.height))));
      imARGB.pixels[x+y*imARGB.width]=color(red(imRGB.get(x,y)),green(imRGB.get(x,y)),blue(imRGB.get(x,y)),alphaValue);
    }
  }
  imARGB.updatePixels(); 
}

public void mousePressed() {
  if (mouseX>=40 && mouseX<=140 && mouseY>=40 && mouseY<=140) {
    if (!loA) {
      FileDialog fileDialog = new FileDialog(frame, "open", FileDialog.LOAD);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        loadImA(fileDialog.getDirectory() + fileDialog.getFile());
        generateARGB();
        loA=true;
        loARGB=true;
      }
    }
    else{
      FileDialog fileDialog = new FileDialog(frame, "save", FileDialog.SAVE);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        imA.save(fileDialog.getDirectory() + fileDialog.getFile());
      }
    }
  }
  if (mouseX>=160 && mouseX<=260 && mouseY>=40 && mouseY<=140) {
    if (!loRGB) {
      FileDialog fileDialog = new FileDialog(frame, "open", FileDialog.LOAD);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        loadImRGB(fileDialog.getDirectory() + fileDialog.getFile());
        generateARGB();
        loRGB=true;
        loARGB=true;
      }
    }
    else{
      FileDialog fileDialog = new FileDialog(frame, "save", FileDialog.SAVE);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        imRGB.save(fileDialog.getDirectory() + fileDialog.getFile());
      }
    }
  }
  if (mouseX>=100 && mouseX<=200 && mouseY>=160 && mouseY<=260) {
    if (!loARGB) {
      FileDialog fileDialog = new FileDialog(frame, "open", FileDialog.LOAD);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        loadImA(fileDialog.getDirectory() + fileDialog.getFile());
        loadImRGB(fileDialog.getDirectory() + fileDialog.getFile());
        generateARGB();
        loA=true;
        loRGB=true;
        loARGB=true;
      }
    }
    else{
      FileDialog fileDialog = new FileDialog(frame, "save", FileDialog.SAVE);
      fileDialog.setVisible(true);
      if (fileDialog.getDirectory()!=null) {
        imARGB.save(fileDialog.getDirectory() + fileDialog.getFile());
      }
    }
  }
}











  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#c0c0c0", "applyalpha" });
  }
}
