
class Marker {

  int[] time = new int[width];
  boolean displayMe;

  Marker() {
    for (int i=0;i<time.length;i++) {
      time[i]=-1;
    }
    displayMe = true;
  }

  void commit() {
    displayMe=false;
    // interpolate
    time[0]=0;
    int maxValue=0;
    for (int i=0;i<time.length;i++) {
      if (time[i]>maxValue) maxValue = time[i];
    }
    time[time.length-1]=maxValue;
    for (int i=0;i<time.length;i++) {
      if (time[i]==-1) {
        int lastTime=i;
        int nextTime=i;
        while (lastTime>0 && time[lastTime]==-1) lastTime--;
        while (nextTime<time.length-1 && time[nextTime]==-1) nextTime++;
        float proportion = (float)(i-lastTime) / (nextTime-lastTime);
        time[i] = floor(time[lastTime] + proportion*(time[nextTime]-time[lastTime]));
      }
    }
    for (int i=0;i<halos.size();i++) {
      if (((Halo)halos.get(i)).points.size()>0) {
        ((Halo)halos.get(i)).inMs=time[constrain(((Halo)halos.get(i)).firstAppear(),0,width-1)];
        ((Halo)halos.get(i)).outMs=time[constrain(((Halo)halos.get(i)).lastAppear(),0,width-1)];
      }
    }
  }

  void display() {
    if (displayMe) {
      noFill();
      stroke(0,0xD0,0xD0);
      for (int i=0;i<time.length;i++) {
        if (time[i]!=-1) {
          line(i,0,i,height);
        }
      }
    }
  }

  void setMarker(int x,int t) {
    if (x<time.length) {
      time[x]=t;
    }
  }
}

