/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import processing.core.PApplet;

public class p5SoundCombiner
extends PApplet {
    public void setup() {
        WavFile wavFile = WavFile.readFromFilePath(this.getDialogFileUrl("file A"));
        WavFile wavFile2 = WavFile.readFromFilePath(this.getDialogFileUrl("file B"));
        String string = this.getDialogFileUrl("save to folder");
        double[][] dArray = wavFile.samplesAsDouble();
        double[][] dArray2 = wavFile2.samplesAsDouble();
        double[][] dArray3 = this.convolveFFT(dArray, dArray2, 8);
        dArray3 = this.normalizeArray(dArray3);
        wavFile.setSamplesFromDouble(dArray3);
        wavFile.writeToFilePath(String.valueOf(string) + "convolved.wav");
        double[][] dArray4 = this.ringMod(dArray, dArray2);
        dArray4 = this.normalizeArray(dArray4);
        wavFile.setSamplesFromDouble(dArray4);
        wavFile.writeToFilePath(String.valueOf(string) + "ringMod.wav");
        double[][] dArray5 = this.ampMod(dArray, dArray2);
        dArray5 = this.normalizeArray(dArray5);
        wavFile.setSamplesFromDouble(dArray5);
        wavFile.writeToFilePath(String.valueOf(string) + "ampMod.wav");
    }

    public void draw() {
    }

    public double[][][][] performDFT(double[][] dArray, int n) {
        int n2 = dArray.length;
        int n3 = (int)p5SoundCombiner.pow((float)2.0f, (float)n);
        double[][][][] dArray2 = new double[2][n2][][];
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6 = dArray[n4].length;
            int n7 = p5SoundCombiner.ceil((float)(n6 / n3));
            int n8 = n3;
            float[][] fArray = new float[n8][n7];
            float[][] fArray2 = new float[n8][n7];
            int n9 = 0;
            while (n9 < n8) {
                n5 = 0;
                while (n5 < n7) {
                    fArray[n9][n5] = 0.0f;
                    fArray2[n9][n5] = 0.0f;
                    int n10 = 0;
                    while (n10 < n3) {
                        float f = (float)(n10 + n5 * n3) * (float)n9 * ((float)Math.PI * 2) / (float)n3;
                        float[] fArray3 = fArray[n9];
                        int n11 = n5;
                        fArray3[n11] = (float)((double)fArray3[n11] + dArray[n4][(n10 + n5 * n3) % n6] * (double)p5SoundCombiner.sin((float)f));
                        float[] fArray4 = fArray2[n9];
                        int n12 = n5;
                        fArray4[n12] = (float)((double)fArray4[n12] + dArray[n4][(n10 + n5 * n3) % n6] * (double)p5SoundCombiner.cos((float)f));
                        ++n10;
                    }
                    ++n5;
                }
                ++n9;
            }
            dArray2[0][n4] = new double[n8][n7];
            dArray2[1][n4] = new double[n8][n7];
            n9 = 0;
            while (n9 < n8) {
                n5 = 0;
                while (n5 < n7) {
                    dArray2[0][n4][n9][n5] = 2.0f * p5SoundCombiner.sqrt((float)(p5SoundCombiner.sq((float)fArray[n9][n5]) + p5SoundCombiner.sq((float)fArray2[n9][n5]))) / (float)n3;
                    dArray2[1][n4][n9][n5] = p5SoundCombiner.atan2((float)fArray2[n9][n5], (float)fArray[n9][n5]);
                    ++n5;
                }
                ++n9;
            }
            ++n4;
        }
        return dArray2;
    }

    public double[][] resynthDFT(double[][][][] dArray, int n) {
        int n2 = (int)p5SoundCombiner.pow((float)2.0f, (float)n);
        int n3 = dArray[0].length;
        double[][] dArrayArray = new double[n3][];
        int n4 = 0;
        while (n4 < n3) {
            double[][] dArray2 = dArray[0][n4];
            double[][] dArray3 = dArray[1][n4];
            int n5 = n2 * dArray2[0].length;
            int n6 = dArray2.length;
            dArrayArray[n4] = new double[n5];
            int n7 = 0;
            while (n7 < n5) {
                dArrayArray[n4][n7] = 0.0;
                ++n7;
            }
            n7 = 0;
            while (n7 < n5) {
                int n8 = p5SoundCombiner.floor((float)((float)n7 / (float)n2));
                int n9 = n7 % n2;
                double d = 0.0;
                int n10 = 0;
                while (n10 < n6) {
                    double d2 = (double)n9 * 6.2831854820251465 * (double)n10 / (double)n2 + dArray3[n10][n8];
                    d += Math.sin(d2) * dArray2[n10][n8];
                    ++n10;
                }
                dArrayArray[n4][n7] = d;
                ++n7;
            }
            ++n4;
        }
        return dArrayArray;
    }

    public float vrMax(float f, float f2, float f3) {
        float f4 = f2 - f;
        if (f4 > f3 / 2.0f) {
            f4 -= f3;
        }
        if (f4 < -f3 / 2.0f) {
            f4 += f3;
        }
        return f4;
    }

    public String getDialogFileUrl(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            return string2;
        }
        return null;
    }

    public String getDialogFolderUrl(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        fileDialog.setVisible(true);
        return fileDialog.getDirectory();
    }

    public String[] getDialogAllFilesUrl(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        fileDialog.setVisible(true);
        return this.getAllFilesFrom(fileDialog.getDirectory());
    }

    public String[] getAllFilesFrom(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            stringArray[n] = fileArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public void renameFile(String string, String string2) {
        File file;
        File file2 = new File(this.sketchPath(string));
        boolean bl = file2.renameTo(file = new File(this.sketchPath(string2)));
        if (!bl) {
            p5SoundCombiner.println((String)(String.valueOf(string) + " was not renamed to " + string2));
        }
    }

    public void copyDirectory(String string, String string2) throws IOException {
        File file = new File(this.sketchPath(string));
        File file2 = new File(this.sketchPath(string2));
        try {
            this.copyDirectoryRec(file, file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void copyDirectoryRec(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                this.copyDirectoryRec(new File(file, stringArray[n]), new File(file2, stringArray[n]));
                ++n;
            }
        } else {
            this.copyFile(file, file2);
        }
    }

    public void copyFile(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public double[][] normalizeArray(double[][] dArray) {
        int n;
        double[][] dArrayArray = new double[dArray.length][];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArrayArray[n2] = new double[dArray[n2].length];
            ++n2;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < dArray.length) {
            n = 0;
            while (n < dArray[n3].length) {
                if (this.abs(dArray[n3][n]) > d) {
                    d = this.abs(dArray[n3][n]);
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < dArray.length) {
            n = 0;
            while (n < dArray[n3].length) {
                dArrayArray[n3][n] = dArray[n3][n] / d;
                ++n;
            }
            ++n3;
        }
        return dArrayArray;
    }

    public double[][] invertArray(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArrayArray[n][n2] = dArray[n][dArray[n].length - n2 - 1];
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double abs(double d) {
        if (d < 0.0) {
            d *= -1.0;
        }
        return d;
    }

    public double[][] simpleIRFilter(double[][] dArray, float f) {
        f = p5SoundCombiner.sqrt((float)f);
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArrayArray[n][n2] = dArray[n][n2] * (double)(1.0f - f);
                double[] dArray2 = dArrayArray[n];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArrayArray[n][p5SoundCombiner.max((int)(n2 - 1), (int)0)] * (double)f;
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double[][] addArrays(double[][] dArray, double[][] dArray2) {
        double[][] dArrayArray = new double[p5SoundCombiner.max((int)dArray.length, (int)dArray2.length)][];
        int n = 0;
        while (n < dArrayArray.length) {
            dArrayArray[n] = new double[p5SoundCombiner.max((int)dArray[n].length, (int)dArray2[n].length)];
            int n2 = 0;
            while (n2 < dArrayArray[n].length) {
                dArrayArray[n][n2] = dArray[n][n2 % dArray[n].length] + dArray2[n][n2 % dArray2[n].length];
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double[][] invertPhase(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArrayArray.length) {
            dArrayArray[n] = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < dArrayArray[n].length) {
                dArrayArray[n][n2] = dArray[n][n2] * -1.0;
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double[][] ringMod(double[][] dArray, double[][] dArray2) {
        double[][] dArrayArray = new double[p5SoundCombiner.max((int)dArray.length, (int)dArray2.length)][];
        int n = 0;
        while (n < dArrayArray.length) {
            dArrayArray[n] = new double[p5SoundCombiner.max((int)dArray[n].length, (int)dArray2[n].length)];
            int n2 = 0;
            while (n2 < dArrayArray[n].length) {
                dArrayArray[n][n2] = dArray[n][n2 % dArray[n].length] * dArray2[n][n2 % dArray2[n].length];
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double[][] ampMod(double[][] dArray, double[][] dArray2) {
        double[][] dArrayArray = new double[p5SoundCombiner.max((int)dArray.length, (int)dArray2.length)][];
        int n = 0;
        while (n < dArrayArray.length) {
            dArrayArray[n] = new double[p5SoundCombiner.max((int)dArray[n].length, (int)dArray2[n].length)];
            int n2 = 0;
            while (n2 < dArrayArray[n].length) {
                dArrayArray[n][n2] = dArray[n][n2 % dArray[n].length] * this.abs(dArray2[n][n2 % dArray2[n].length]);
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public double[][] arrayOfSize(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = new double[dArray[n].length];
            ++n;
        }
        return dArrayArray;
    }

    public Complex[][][] performFFT(double[][] dArray, int n) {
        int n2 = dArray.length;
        int n3 = (int)p5SoundCombiner.pow((float)2.0f, (float)n);
        Complex[][][] complexArray = new Complex[n2][][];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = dArray[n4].length;
            int n6 = p5SoundCombiner.ceil((float)(n5 / n3));
            complexArray[n4] = new Complex[n6][];
            int n7 = 0;
            while (n7 < n6) {
                Complex[] complexArray2 = new Complex[n3];
                int n8 = 0;
                while (n8 < n3) {
                    complexArray2[n8] = new Complex(dArray[n4][(n8 + n7 * n3) % n5], 0.0);
                    ++n8;
                }
                Complex[] complexArray3 = FFT.fft(complexArray2);
                complexArray[n4][n7] = new Complex[complexArray3.length];
                int n9 = 0;
                while (n9 < complexArray3.length) {
                    complexArray[n4][n7][n9] = complexArray3[n9];
                    ++n9;
                }
                ++n7;
            }
            ++n4;
        }
        return complexArray;
    }

    public double[][] resynthFFT(Complex[][][] complexArray, int n) {
        int n2 = (int)p5SoundCombiner.pow((float)2.0f, (float)n);
        int n3 = complexArray.length;
        double[][] dArrayArray = new double[n3][];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = complexArray[n4].length;
            int n6 = n2 * n5;
            int cfr_ignored_0 = complexArray[n4][0].length;
            dArrayArray[n4] = new double[n6];
            int n7 = 0;
            while (n7 < n6) {
                dArrayArray[n4][n7] = 0.0;
                ++n7;
            }
            n7 = 0;
            while (n7 < n5) {
                Complex[] complexArray2 = FFT.ifft(complexArray[n4][n7]);
                int n8 = 0;
                while (n8 < complexArray2.length) {
                    dArrayArray[n4][n7 * n2 + n8] = complexArray2[n8].re();
                    ++n8;
                }
                ++n7;
            }
            ++n4;
        }
        return dArrayArray;
    }

    public double[][][][] shiftDFT(double[][][][] dArray, int n) {
        double[][][][] dArrayArray = new double[dArray.length][][][];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArrayArray[n2] = new double[dArray[n2].length][][];
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                dArrayArray[n2][n3] = new double[dArray[n2][n3].length][];
                int n4 = 0;
                while (n4 < dArray[n2][n3].length) {
                    dArrayArray[n2][n3][n4] = new double[dArray[n2][n3][n4].length];
                    int n5 = 0;
                    while (n5 < dArray[n2][n3][n4].length) {
                        dArrayArray[n2][n3][n4][n5] = dArray[n2][n3][(n4 + n) % dArray[n2][n3].length][n5];
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return dArrayArray;
    }

    public double[][] convolveFFT(double[][] dArray, double[][] dArray2, int n) {
        int n2 = p5SoundCombiner.max((int)dArray.length, (int)dArray2.length);
        int n3 = (int)p5SoundCombiner.pow((float)2.0f, (float)n);
        double[][] dArrayArray = new double[n2][];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = dArray[n4 % dArray.length].length;
            int n6 = dArray2[n4 % dArray2.length].length;
            int n7 = p5SoundCombiner.max((int)n5, (int)n6);
            int n8 = p5SoundCombiner.ceil((float)(n7 / n3));
            dArrayArray[n4] = new double[n8 * n3];
            int n9 = 0;
            while (n9 < n8) {
                Complex[] complexArray = new Complex[n3];
                Complex[] complexArray2 = new Complex[n3];
                int n10 = 0;
                while (n10 < n3) {
                    complexArray[n10] = new Complex(dArray[n4][(n10 + n9 * n3) % n5], 0.0);
                    complexArray2[n10] = new Complex(dArray2[n4][(n10 + n9 * n3) % n6], 0.0);
                    ++n10;
                }
                Complex[] complexArray3 = FFT.convolve(complexArray, complexArray2);
                int n11 = 0;
                while (n11 < n3) {
                    dArrayArray[n4][n9 * n3 + n11] = complexArray3[n11 * 2].re();
                    ++n11;
                }
                ++n9;
            }
            ++n4;
        }
        return dArrayArray;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#D4D0C8", "p5SoundCombiner"});
    }
}

