/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import krister.Ess.AudioChannel;
import krister.Ess.AudioInput;
import krister.Ess.AudioStream;
import processing.core.PApplet;

public final class Ess {
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BUFFER_SIZE = (int)Math.pow(2.0, Math.ceil(Math.log(7350.0) / Math.log(2.0)));
    public static final int BEGINNING = 1;
    public static final int END = 2;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int MIX = 2;
    public static final int AIFF = 1;
    public static final int WAVE = 2;
    public static final int STOPPED = 1;
    public static final int PLAYING = 2;
    public static final int RECORDING = 3;
    public static final int FOREVER = -1;
    public static final int SLOW = 1;
    public static final int FAST = 2;
    public static final int LINEAR = 3;
    public static final int REPLACE = 1;
    public static final int ADD = 2;
    public static final int SUBTRACT = 3;
    public static final int JAVASOUND = 1;
    public static final int COREAUDIO = 2;
    public static final int READ = 1;
    public static final int WRITE = 2;
    protected static PApplet parent;
    protected static ThreadGroup tg;
    private static Mixer inputMixer;
    protected static Mixer outputMixer;
    private static ArrayList audioChannelRegistry;
    private static ArrayList audioStreamRegistry;
    private static ArrayList audioInputRegistry;
    private static float rMasterVolume;
    private static boolean rMasterMute;
    private static int rEngine;
    public static float masterVolume;
    public static boolean masterMute;
    public static int engine;
    public static AudioInput activeAudioInput;
    protected static AudioFormat inputFormat;
    protected static DataLine.Info inputInfo;
    protected static TargetDataLine inputLine;
    private static AudioInput rActiveAudioInput;
    private static float inputSampleRate;
    private static int inputBufferSize;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    public static final void start(PApplet pApplet) {
        Ess.start(pApplet, 1);
    }

    public static final void start(PApplet pApplet, int n) {
        parent = pApplet;
        tg = new ThreadGroup("Ess");
        audioChannelRegistry = new ArrayList();
        audioStreamRegistry = new ArrayList();
        audioInputRegistry = new ArrayList();
        if (n == 2) {
            PApplet.println("Warning: CoreAudio not available. Reverting to JavaSound");
            n = 1;
        }
        engine = rEngine = n;
        outputMixer = AudioSystem.getMixer(null);
        Ess.masterVolume(1.0f);
        Ess.masterMute(false);
    }

    public static final void stop() {
        Ess.dispose();
    }

    public static final void dispose() {
        if (audioChannelRegistry != null) {
            while (!audioChannelRegistry.isEmpty()) {
                ((AudioChannel)audioChannelRegistry.get(0)).destroy();
            }
        }
        if (audioStreamRegistry != null) {
            while (!audioStreamRegistry.isEmpty()) {
                ((AudioStream)audioStreamRegistry.get(0)).destroy();
            }
        }
        if (audioInputRegistry != null) {
            while (!audioInputRegistry.isEmpty()) {
                ((AudioInput)audioInputRegistry.get(0)).destroy();
            }
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (threadArray[i].getName().indexOf("Sound") == -1) continue;
            threadArray[i].interrupt();
        }
        audioChannelRegistry = null;
        audioStreamRegistry = null;
        audioInputRegistry = null;
    }

    public static final void masterVolume(float f) {
        masterVolume = rMasterVolume = f;
    }

    public static final void masterMute(boolean bl) {
        masterMute = rMasterMute = bl;
    }

    public static final void stopAllInputs() {
        int n = audioInputRegistry.size();
        for (int i = 0; i < n; ++i) {
            ((AudioInput)audioInputRegistry.get(i)).stop();
        }
    }

    public static final void stopAllOutputs() {
        int n;
        int n2 = audioChannelRegistry.size();
        for (n = 0; n < n2; ++n) {
            ((AudioChannel)audioChannelRegistry.get(n)).stop();
        }
        n2 = audioStreamRegistry.size();
        for (n = 0; n < n2; ++n) {
            ((AudioStream)audioStreamRegistry.get(n)).stop();
        }
    }

    public static final int ms(int n, float f) {
        return (int)((float)n / f * 1000.0f);
    }

    public static final int frames(int n, float f) {
        return (int)((float)n * f / 1000.0f);
    }

    public static final float calcShift(float f) {
        return (float)Math.pow(2.0, f / 12.0f);
    }

    protected static final int getFrame(byte[] byArray, int n) {
        int n2 = byArray[n *= 2] << 8;
        return n2 |= byArray[n + 1] & 0xFF;
    }

    protected static final void setFrame(byte[] byArray, int n, int n2) {
        byArray[n *= 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    protected static final float semiBezier(float f, float f2, float f3, float f4) {
        float f5 = 3.0f * (f3 - f);
        float f6 = -f5;
        float f7 = f2 - f;
        return f7 * f4 * f4 * f4 + f6 * f4 * f4 + f5 * f4 + f;
    }

    protected static final float[] rateConvert(float[] fArray, float f, float f2) {
        return Ess.rateConvert(fArray, f, f2, 0, fArray.length);
    }

    protected static final float[] rateConvert(float[] fArray, float f, float f2, int n, int n2) {
        float f3 = f / f2;
        int n3 = Math.min(fArray.length, n2 + n) - n;
        int n4 = (int)((float)n3 / f3);
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f4 = f3 * (float)i - 1.0f;
            int n5 = (int)Math.floor(f4);
            fArray2[i] = fArray[Math.max(0, n5)];
        }
        return fArray2;
    }

    protected static final void registerAudioChannel(AudioChannel audioChannel) {
        audioChannelRegistry.add(audioChannel);
    }

    protected static final void unregisterAudioChannel(AudioChannel audioChannel) {
        int n = audioChannelRegistry.indexOf(audioChannel);
        if (n != -1) {
            audioChannelRegistry.remove(n);
        }
    }

    protected static final void registerAudioStream(AudioStream audioStream) {
        audioStreamRegistry.add(audioStream);
    }

    protected static final void unregisterAudioStream(AudioStream audioStream) {
        int n = audioStreamRegistry.indexOf(audioStream);
        if (n != -1) {
            audioStreamRegistry.remove(n);
        }
    }

    protected static final void registerAudioInput(AudioInput audioInput) {
        audioInputRegistry.add(audioInput);
    }

    protected static final void unregisterAudioInput(AudioInput audioInput) {
        int n = audioInputRegistry.indexOf(audioInput);
        if (n != -1) {
            audioInputRegistry.remove(n);
        }
    }

    protected static final float getMasterVolume() {
        return rMasterVolume;
    }

    protected static final boolean getMasterMute() {
        return rMasterMute;
    }

    protected static final void setupInput() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            if (!AudioSystem.getMixer(infoArray[i]).isLineSupported(new Line.Info(class$javax$sound$sampled$TargetDataLine == null ? Ess.class$("javax.sound.sampled.TargetDataLine") : class$javax$sound$sampled$TargetDataLine))) continue;
            inputMixer = AudioSystem.getMixer(infoArray[i]);
            break;
        }
    }

    protected static final void startInput(AudioInput audioInput, int n, float f) {
        if (inputMixer == null) {
            Ess.setupInput();
        }
        if (audioInput != rActiveAudioInput || n != inputBufferSize || f != inputSampleRate) {
            if (rActiveAudioInput != null) {
                Ess.stopInput(rActiveAudioInput);
            }
            inputFormat = new AudioFormat(f, 16, 2, true, true);
            inputInfo = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = Ess.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, inputFormat);
            try {
                inputLine = (TargetDataLine)inputMixer.getLine(inputInfo);
                inputLine.open(inputFormat, n * 2 * 2 * 4);
                inputLine.start();
                inputBufferSize = n;
                inputSampleRate = f;
                activeAudioInput = rActiveAudioInput = audioInput;
            }
            catch (LineUnavailableException lineUnavailableException) {
                lineUnavailableException.printStackTrace();
            }
        } else {
            inputLine.flush();
        }
    }

    protected static final void stopInput(AudioInput audioInput) {
        if (rActiveAudioInput == audioInput) {
            if (inputLine != null) {
                inputLine.stop();
                inputLine.drain();
                inputLine.close();
            }
            rActiveAudioInput = null;
            activeAudioInput = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        activeAudioInput = null;
        rActiveAudioInput = null;
    }
}

